#include "SetOSDText.h"
#include "SetOSDPicture.h"
#include "SetOSDBuffer.h"

// MyOSDPropertyDlg.h : header file
//

#pragma once


// CMyOSDPropertyDlg dialog
class CMyOSDPropertyDlg : public CDialogEx
{
// Construction
public:
	CMyOSDPropertyDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_MYOSDPROPERTY_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();	
	afx_msg void OnBnClickedBtnSetOsdText();
	afx_msg void OnBnClickedBtnSetOsdPicture();
	afx_msg void OnBnClickedBtnSetOsdBuffer();	
	afx_msg void OnBnClickedBtnOk();
	DECLARE_MESSAGE_MAP()

public:

	DEVICE_HANDLE				m_hVideoDev;

	PVOID									m_pOSDAlphaBlender;

	ULONG								m_nVideoFrameWidth;

	ULONG								m_nVideoFrameHeight;
	
	DOUBLE								m_dVideoFrameRate;

	CSetOSDText						m_DlgSetOSDText;

	CSetOSDPicture					m_DlgSetOSDPicture;

	CSetOSDBuffer					m_DlgSetOSDBuffer;

public:
	
	BOOL				GetCurrentDeviceFormat( ULONG * pVideoWidth, ULONG * pVideoHeight, BOOL *  pVideoIsInterleaved, ULONG * pVideoFrameRate,  ULONG * pAudioChannels,  ULONG * pAudioBitsPerSample, ULONG * pAudioSampleFrequency );
};
